﻿  ﻿  ' '***The pressure arrow icon font is "various_symbols"  ***
  '*****You HAVE to install this font to make this arrow work*****
  '*** save to the Library as FONT 8 *********
  cls
  option explicit
  OPTION AUTORUN on ' Program will autorun after power loss *** ONLY works if the program is run at least once ***
  ' global arrays
  Dim MinFlag  'if you need to do someting every minute
  Dim NewDataFlag
  DIM ESPT$,ESP$,DD$,MM$,temp1$,temp2$,ICON$,hum1$,hum2$,DESC0$,desc2$,speed$,press1$,press2$,angle1$,Month1$,Line1$,Line2$
  dim uv$,uv2$,vis$,tempmin$,tempmax$,tempmin1$,tempmax1$,rain$,tim$,rain44$,oldHour$,tt1$,dow1$,dm1$,Year1$,Day1$
  dim uv1,sunrise,sunset,year,month,day,hour,min,sec,secs,UseDST,mins,TimeZone,dow2$,dow3$,dow4$,dow5$
  dim descd2$,speedd2$,pressd3$,humidd3$,tempmind3$,tempd3$,descd3$,speedd3$,pressd4$,humidd4$,tempmind4$,tempd4$,descd4$
  dim speedd4$,pressd5$,humidd5$,tempmind5$,tempd5$,descd5$,speedd5$,pressd6$,humidd6$,tempmind6$,tempd6$,descd6$,speedd6$
  dim t1tmp,t2tmp,t3tmp,t4tmp,prs1tmp,prs2tmp,spdtmp  'temp values
  oldHour$ = "00" ' set so the time correcly updates when first run else the clock would be wrong for the 1st hour
  Dim md(12), arg$(20),i,dms,dhs,dme,dhe
  DIM FLOAT temp ,humidity    'ONLY USE THIS if you're using a DHT22  temp/humidity sensor
  HUMID 59, temp, humidity   'ONLY USE THIS if you're using a DHT22  temp/humidity sensor
  'DIM float Tempr  'USE THIS if you're using a DS18B20 temp sensor
  DIM FieldArray$(50) 'Max number of fields recieved by serial port 2
  
  '****The folllowing 2 Fonts are from the "various_symbols font" in the Embedded Fonts folder in the MM firmware zip*****
  dim string ZA = chr$(79)   'Up arrow      *** USES FONT 8 ****
  dim string ZB = chr$(80)  'Down arrow    *** USES FONT 8 ****
  'COMMENT OUT IF you don't want to use the UP and Down arrow for Pressure rising or lowering*
  '********************************** I Installed them in the Library as FONT 8**************************************
  
  const pivot_x=501   'specify where the centre of the Compass dial is located
  const pivot_y=387
  const radius=73   'specify the radius of the compass dial
  const side_length=13    'specify the size of the equilateral triangle pointer
  'define the points that make up the triangle relative to a pivot at 0,0
  const x0=0
  const x1=-side_length/2
  const x2=side_length/2
  const y0=-radius
  const y1=-radius+side_length*cos(rad(30))
  const y2=y1
  dim integer angle, X, Y, W, H
  dim integer xx0,xx1,xx2,yy0,yy1,yy2   'variables holding the vertices of the triangle relative to its pivot
  dim integer pxx0,pxx1,pxx2,pyy0,pyy1,pyy2 'variables holding the absolute vertices of the triangle
  
  TimeZone = 0        ' hours from GMT/UTC (+ or -)
  UseDST = 1            ' set to 1 to enable daylight saving time (BST/AWT/DST) adjust
  dms = 3              ' the month that DST starts
  dhs = 2               ' the hour that DST starts
  dme = 10               ' the month that DST ends
  dhe = 1               ' the hour that DST ends
  Data 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334
  For i = 1 To 12: Read md(i): Next i
  TEXT 150,60,"Weather Station", LM, 4, 2, RGB(RED)
  TEXT 80,180,"INITIALISING ESP8266", LM, 4, 2, RGB(136,184,62)
  TEXT 40,260,"Please wait 50 seconds", LM, 4, 2, RGB(136,184,62)
  TEXT 20,400,"This is to eliminate errors on the screen when the ESP boots up", LM, 2, 1, RGB(BLUE)
  
   pause 50000 "This is to eliminate errors on the screen when the ESP boots up" Because the ESP sends boot up data and the string is too long for the MM to process
  
  cls
  time$ = "00:00:00" ' set clock (probably not needed but included anyway)
  Init:
  
  Open "COM2:9600, 1024, ESPIsr"  As #2   'Open port for ESP8266
  '****** CHANGE ABOVE LINE TO COM3 IF USING A CLICK BOARD or whatever com port you are using*********
  '******************************************************************************************************************
  
  load image "image.bmp" ,400,280  'load compass picture
  load image "temperature.bmp",563,37 'temp icon
  'circle pivot_x,pivot_y,radius+1   'draw the rim of the dial  to show if the centre of the pivot lines up ** FOR TEST to make sure the centre of the picture is correct **
  'circle 501,388,53,2,,RgB(red)  'draw the inner of the dial to show if the centre of the pivot lines up ** FOR TEST  to make sure the centre of the picture is correct **
  RBOX 00,00,396,100,15, RGB(136,184,62), RGB(12,26,8)   ' Box around  time
  RBOX 400,00,400,98,15, RGB(200,148,77), RGB(22,20,15)  ' Box around  temp
  RBOX 400,101,400,98,15, RGB(200,148,77), RGB(48,35,29) ' Box around  pressure
  RBOX 400,202,400,75,15, RGB(200,148,77), RGB(22,20,15)' Box around  min/max temp
  RBOX 603,280,400,194,15, RGB(67,157,229), RGB(25,28,37)  ' Box around  UV Index box
  RBOX 400,280,200,200,15, RGB(215,255,119) ' Box around compass
  RBOX 00,101,396,150,15, RGB(67,157,229)   ' Box around Weather icon
  RBOX 00,284,194,90,15, RGB(200,148,77), RGB(48,35,29)  ' Box around Humidity
  rbox 20,286,160,30,15,  RGB(48,35,29),RGB(202,245,255) 'box around humidity writing
  RBOX 198,284,198,90,15, RGB(200,148,77), rgb(20, 20, 20)  ' Box around  Sunrise/sunset
  rbox 205,286,184,30,15, RGB(22,20,15),RGB(200,148,77) 'box around Sunrise/set writing
  Text 210,301,  "Sunrise/set" , LM, 1, 2, RGB(22,20,15),RGB(200,148,77)  'print Sunrise/set
  RBOX 198,377,198,90,15, RGB(136,184,62), RGB(12,26,8)   'box around description
  rbox 410,5,180,30,15, RGB(22,20,15),RGB(200,148,77)   'box around indoor C
  rbox 603,5,180,30,15, RGB(22,20,15),RGB(200,148,77) 'box around outdoor C
  rbox 450,105,300,30,15, RGB(48,35,29),RGB(202,245,255) 'box around air pressure
  rbox 420,205,360,30,15, RGB(22,20,15),RGB(200,148,77)   'box around min/max temp
  rbox 620,286,160,30,15, RGB(25,28,37), RGB(67,157,229) 'box around uv index
  rbox 625,398,150,30,15, RGB(25,28,37), RGB(67,157,229)  'box around visability
  rbox 406,283,63,26,15, RGB(12,26,8), RGB(215,255,119)  'box around Wind
  RBOX 55,253,280,30,15, RGB(136,184,62) , RGB(12,26,8)  'box around "Weather tomorrow"
  RBOX 198,377,198,90,15, RGB(136,184,62), RGB(12,26,8)   'box around tomorrow's description
  RBOX 00,377,194,90,15, RGB(136,184,62), RGB(12,26,8) 'box around tomorrow's temp
  rbox 20,380,160,30,15, RGB(12,26,8), RGB(136,184,62)   'box around temp writing tomorrow
  RBOX 198,377,198,90,15, RGB(67,157,229), RGB(25,28,37)   'box around tomorrow's description
  rbox 203,380,190,30,15, RGB(25,28,37), RGB(67,157,229)  'box around description writing
  Text 610,21,  "Outdoor `C" , LM, 1, 2, RGB(22,20,15),RGB(200,148,77)  'print °C outdoor
  Text 420,21,  "Indoor `C" , LM, 1, 2, RGB(22,20,15),RGB(200,148,77)  'Print °C indoor
  Text 470,120, "Air Pressure mb" , LM, 1, 2, RGB(48,35,29),RGB(202,245,255)  'print Pressure
  Text 475,360, "MPH", LM,4, 1, RGB(215,255,119),RGB(34,49,22)   'print MPH
  Text 415,296,  "Wind" , LM, 2, 1, RGB(12,26,8),RGB(215,255,119)  'print WIND
  TEXT 630,300, "UV Index ", LM,1,2,RGB(25,28,37),RGB(67,157,229) 'print UV Index
  TEXT 640,414, "Visability ", LM,2,1,RGB(25,28,37),RGB(67,157,229)  'Visability
  Text 440,219,  "Min Temp `C Max Temp" , LM, 1, 2, RGB(22,20,15),RGB(200,148,77)    'Print Min/Max Temp
  Text 35,301,  "Humidity" , LM, 1, 2,  RGB(48,35,29),RGB(202,245,255)  'print humidity
  TEXT 67,268,"Weather tomorrow", LM, 1, 2, RGB(136,184,62) , RGB(12,26,8)  'print weather tomorrow
  TEXT 35,395,"Temp `C", LM, 1, 2, RGB(12,26,8), RGB(136,184,62)    'print Temp °C
  rbox 165,110,200,30,15, RGB(47,40,32), RGB(47,40,32)  'box around description today writing
  TEXT 175,124,"Description", LM, 1, 2, RGB(202,245,255), RGB(47,40,32) 'print description today
  TEXT 210,395,"Description", LM, 1, 2, RGB(25,28,37),RGB(67,157,229)  'print weather tomorrow
  TEXT 80,30, "Please Wait",LM,4, 1, rGB(136,184,62), RGB(12,26,8)  'print "please wait"
  TEXT 60,50, "For Time Sync",LM,4, 1, rGB(136,184,62), RGB(12,26,8)  'For Time Sync"
   pause 20000   'pause 20 seconds to prevent errors the 1st time we display the ESP8266 data - Frr Some WIERD reason the 1st time we receive the time update it messes up the screen
  TEXT 80,30, "           ",LM,4, 1, rGB(136,184,62), RGB(12,26,8)  'clear "please wait"
  TEXT 60,50, "             ",LM,4, 1, rGB(136,184,62), RGB(12,26,8)  'clear Time Sync"
  watchdog 1800000     'If program stops for 30 mins then the cpu reboots
  
  'interupts'
  SetTick 1000,UpDateTime,1   'Call every second, print date/time
  
  ' *****GUI INTERRUPT PenDown 'Important line, without it Pendown won't be called *FUTURE USE for FORECAST* ***********

  '******************************************************************************************************************
  
  '******************this is the main program loop, it never exits ******************************
  do
    watchdog 300000     'If program stops for 5 mins then the cpu reboots
    
    '************'Set RTC once an hour to it's always correct IF you have an RTC and want to keep it updated **************************
    '                                                                                                                                 *
    '       I put this here so the RTC will always be up correct even with BST/DST changes                                            *
    '    IF STR$(hour) <> oldHour$ THEN ' we are into a new hour  ** Routine to set the RTC clock once an hour                        *
    '       rtc settime year,month,day,VAL(left$(line1$,2)),min,sec                                                                   *
    '       oldHour$ = STR$(hour) ' set the oldHour so we don't do anything until the next hour                                       *
    '    ENDIF                                                                                                                        *
    '**********************************************************************************************************************************
    
    If ESP$ <> "" Then 'Check if a full line of ESP8266 data has arrived
      SERIAL2   'If data in Com2 then GOSUB Serial2
      ESP$ = ""
      load image ICON$,05,115
      'Then do the following***
      Text 640,70, temp1$, LM,2, 2, RGB(200,148,77),RGB(22,20,15)  'print outdoor temp
      Text 640,340, uv$, LM,2, 2, RGB(67,157,229),RGB(25,28,37) 'print UV Index
      Text 455,400, speed$, LM,4, 1, RGB(215,255,119),RGB(34,49,22) 'print Wind Speed
      Text 420,170, press1$, LM,2, 2, RGB(202,245,255) ,RGB(48,35,29) 'print pressure
      Text 610,170, press2$, LM,2, 2, RGB(202,245,255) ,RGB(48,35,29)'print pressure tomorrow
      Text 640,450, vis$+"M", LM,2, 2, RGB(67,157,229),RGB(25,28,37)  'print UV Index
      Text 405,255, tempmin$, LM,2, 2, RGB(200,148,77),RGB(22,20,15) 'print min temp
      Text 620,255, tempmax$, LM,2, 2, RGB(200,148,77),RGB(22,20,15) 'print max temp
      Text 130,200, "    ", LM,1, 2, RGB(200,148,77) 'print humidity today
      Text 130,200, hum1$+"%", LM,1, 2, RGB(200,148,77) 'print humidity today
      Text  55,345, "    ", LM,2, 2, RGB(202,245,255) ,RGB(48,35,29) 'print humidity tomorrow
      Text  55,345, hum2$+"%", LM,2, 2, RGB(202,245,255) ,RGB(48,35,29) 'print humidity tomorrow
      Text  20,440, temp2$, LM,2, 2,  RGB(136,184,62), RGB(12,26,8)  'print temp tomorrow
      Text 240,440, rain$, LM,1, 2, RGB(67,157,229),RGB(25,28,37) 'print description tomorrow
      Text 140,165, "               " , LM, 1, 2, RGB(200,148,77)    'Print the Today's weather description
      Text 140,165, desc0$ , LM, 1, 2, RGB(200,148,77)    'Print the Today'sweather description
      Text 200,200, "Humidity and" , LM, 1, 2, RGB(200,148,77) 'Print the word "with"
      Text 200,230, "           ", LM, 1, 2, RGB(200,148,77)   'Print short weather description
      Text 220,230, rain44$, LM, 1, 2, RGB(200,148,77)   'Print short weather description
      Text 230,331,right$(HumanTime(sunrise),8), LM, 4, 1, RGB(200,148,77),rgb(20, 20, 20)  'print Sunrise/set
      Text 230,361,right$(HumanTime(sunset),8), LM, 4, 1, RGB(200,148,77),rgb(20, 20, 20)  'print Sunrise/set
      'Text 430,70, TEMPR(59), LM,2, 2, RGB(200,148,77),RGB(22,20,15)   'print indoor temp  ***USE THIS if using a DS18B20***
      Text 430,70, STR$(temp,0,1), LM,2, 2, RGB(200,148,77),RGB(22,20,15)    'print indoor temp  ***USE THIS if using a DHT22***COMMENT OUT if using a DS18B20***
      angle = VAL(angle1$)       ' This is the current wind direction
      moveto(angle)          'Move Compass to the current wind direction
    endif
  loop
end
  '*********************************'END of main program loop***********************
  
  '**************************COM PORT routine************************
Sub ESPIsr    'COM2 ESP8266 interrupt handler  - this gets called whenever data comes int Com2
  Local T$
  T$ = Input$(1,#2)          'Get data into temp buffer
  If T$ = CHR$(42) Then
    ESP$ = ESPT$             'Save string to global now that it is complete
    ESPT$ = ""                'Clear ESP Temp string for next line
  Else
    ESPT$ = ESPT$ + T$       'Add new char to ESP Temp input string
  ENDIF
End Sub
  '**************************END OF COM PORT routine************************
  
  '******** Go here once a complete line of data is received ****************
Sub SERIAL2    'Com2 ESP8266 get and parse data
  'TEMPR START(59)  ' Start indoor temp reading   *** USE If using a DS18B20
  LOCAL N as INTEGER
  N=GetFieldArray(ESP$)
  print " ESP$ print 1 "+ESP$   'test print to make sure the serial port routine works
  
  if FieldArray$(1) = "one" then  ' If fieldarray 1  = "one" then gosub Today
    TODAY
    
  elseIF FieldArray$(1) = "two" then  ' If fieldarray 1  = "two" then gosub Forecast
    FORECAST
    
  ENDIF
endif

END SUB
'******** End of Subroutine **********************************************

'********************* Today's weather ****************************************
SUB TODAY
'  PRINT "We got to Today"  ' test to make sure we got here - DELETE when not needed anymore
rain$ = "          "  'to clear the rain box in case of random text there
temp2$ = FieldArray$(2)  'temp tomorrow
ICON$ = left$(FieldArray$(3),3)+".bmp"  'Weather icon
temp1$ = FieldArray$(4)   'outdoor temperature
press1$ = FieldArray$(5) 'Pressure today
speed$ = FieldArray$(6) 'Wind Speed
angle1$ = FieldArray$(7)  'wind direction
hum1$ = FieldArray$(8)   'outdoor humidity
tempmin$ = FieldArray$(9) 'min temp AT THE MOMENT
tempmax$ = FieldArray$(10)   'max temp AT THE MOMENT
hum2$ = FieldArray$(11)   'max temp tomorrow
vis$ = FieldArray$(12)   'Visability
desc0$ = FieldArray$(13)   'weather description
rain44$ = FieldArray$(14)    'weather type **not used**
press2$ = FieldArray$(15)    'pressure tomorrow
uv$ = FieldArray$(16)        'UV Index
tempmin1$ = FieldArray$(17) 'min temp tomorrow
tempmax1$ = FieldArray$(18)   'max temp tomorrow
rain$ = FieldArray$(19)  'rain tomorrow
tt1$ = FieldArray$(20)   'hour:min:sec
dow1$ = FieldArray$(21) 'day of week words
dm1$ = FieldArray$(22)   'day:month
Year1$ = FieldArray$(23) 'Year
sunrise = val(FieldArray$(24)) 'Sunrise
sunset = val(FieldArray$(25)) 'Sunset
CHECKARRAY    'Subroutine to check for "not found"
CHECKMONTH    'Subroutine to get month numberal
UVINDEX    'Subroutine to convert UV index to words
DESCRIPTION  'Subroutine to shorten weather description Subroutine
spdtmp = VAL(speed$)
speed$ = STR$(spdtmp,2,2)
t1tmp = VAL(temp1$)
t2tmp = VAL(temp2$)
t3tmp = VAL(tempmin$)
t4tmp = VAL(tempmax$)
temp1$ = STR$(t1tmp,2,1)
temp2$ = STR$(t2tmp,2,2)
tempmin$ = STR$(t3tmp,2,2)
tempmax$ = STR$(t4tmp,2,2)
prs1tmp = VAL(press1$)
prs2tmp = VAL(press2$)
PRESSICON   'Subroutine to Get the correct pressure icon
press1$ = STR$(prs1tmp,4,2)
press2$ = STR$(prs2tmp,4,2)
day1$ = left$(dm1$,2)
Year = VAL(right$(Year1$,2))'Year
Month1$ = right$(dm1$,3) 'Month
day = VAL(Day1$)         'day in numerals
hour = VAL(Left$(tt1$, 2)) 'hour in numerals
min = Val(Mid$(tt1$, 4, 2)) 'minute in numerals
sec = VAL(right$(tt1$, 2)) 'seconds in numerals

'*********START OF BST/DST TIME CHECK/CONVERT**********************************
mins = GetMins(year, month, day, hour, min)  '
mins = mins + TimeZone * 60                ' adjust for the timezone
If UseDST Then                             ' if we observe daylight saving
  If mins < GetDST(year, dme, dhe) Or mins > GetDST(year, dms, dhs) Then
    mins = mins + 60                       ' adjust for BST/DST
  EndIf
EndIf
'************END OF BST/DST TIME CHECK/CONVERT**********************************
Line2$ = GetTime$(mins)   ' Get the CURRENT Local Time

' print line2$ ' Print time to make sure it's correct - again Delete when no longer needed

IF STR$(hour) <> oldHour$ THEN   ' we are into a new hour  ** Routine to set the MM clock once an hour **                       *
  Time$ = Line2$  ' Set MM clock to the correct time
  oldHour$ = STR$(hour) ' set the oldHour so we don't do anything until the next hour                                       *
ENDIF

PRINT " GOT TO END OF TODAY  - FOR TEST"

End Sub
'********************* END of Today's weather ****************************************



'************FORECAST**************************************************************
SUB FORECAST
print "We got to the Forecast"
descd2$ = FieldArray$(2) 'description tomorrow
speedd2$ = FieldArray$(3)  'speed tomorrow
pressd3$ = FieldArray$(4)  'pressure day 2
humidd3$ = FieldArray$(5)  'humidity day 2
tempmind3$ = FieldArray$(6)  'min temp day 2
tempd3$ = FieldArray$(7)  'temp day 3
descd3$ = FieldArray$(8)  'description day 2
speedd3$ = FieldArray$(9)  'speed day 2
pressd4$ = FieldArray$(10)  'pressure day 3
humidd4$ = FieldArray$(11)  'humidity day 3
tempmind4$ = FieldArray$(12) 'min temp day 3
tempd4$ = FieldArray$(13)   'temp day 3
descd4$ = FieldArray$(14)  'description day 3
speedd4$ = FieldArray$(15)  'speed day 3
pressd5$ = FieldArray$(16)  'pressure day 4
humidd5$ = FieldArray$(17)  'humidity day 4
tempmind5$ = FieldArray$(18)  'min temp day 4
tempd5$ = FieldArray$(19)  'temp day 4
descd5$ = FieldArray$(20)  'description day 4
speedd5$ = FieldArray$(21)  'speed day 4

' THE FOLLOWING PRINTS ARE FOR TEST TO MAKE SURE THIS IS WORKING - DELETE WHEN NOT NEEDED*******************
'These for some reason are picking up the values from "Today Sub" after 1st run
print descd2$  " desc2"
print speedd2$ " speed2"
print pressd3$ " press3"
print humidd3$ " humid3"
print tempmind3$ " tempmind3"
print tempd3$ " tempd3"
print descd3$ " desc3"
print speedd3$ " speed3"
print pressd4$ " press4"
print humidd4$ " humid4"
print tempmind4$ " tempmind4"
print tempd4$ " tempd4"
print descd4$ " desc4"
print speedd4$ " speed4$"
print pressd5$ " press5"
print humidd5$ " humid5"
print tempmind5$ " tempmind5"
print tempd5$ " temp45"
print descd5$ " desc5"
print speedd5$ " speed5"

END SUB
'************END OF FORECAST**************************************************************

'Sub to check for "NOT FOUND" and replace with " " so display does not mess up*********
SUB CHECKARRAY
if temp2$ = "not found" THEN temp2$ = "00"
endif
if icon$ = "not.bmp" then icon$ = "50n.bmp"
endif
if temp1$ = "not found" THEN temp1$ = "00"
endif
IF press1$ = "not found" THEN press1$ = "00"
endif
if speed$ = "not found" THEN speed$ = "00"
endif
IF angle1$ = "not found" THEN angle1$ = "360"
endif
if hum1$ = "not found" THEN hum1$ = "0"
endif
if tempmin$ = "not found" THEN tempmin$ = "00"
endif
if tempmax$ = "not found" THEN tempmax$ = "00"
endif
if hum2$ = "not found" THEN hum2$ = "0"
endif
if vis$ = "not found" THEN vis$ = "00"
endif
if desc0$ = "not found" THEN desc0$ = "00"
endif
if rain44$ = "not found" THEN rain44$ = "00"
endif
if press2$ = "not found" THEN press2$ = "00"
endif
if uv$ = "not found" THEN uv$ = "00"
endif
if tempmin1$ = "not found" THEN tempmin1$ = "00"
endif
if tempmax1$ = "not found"THEN tempmax1$ = "00"
endif
if rain$ = "not found" THEN rain$ = "00"
endif
if tt1$ = "not found" THEN tt1$ = "00:00:00 "
endif
if dm1$ = "not found" then dm1$ = "01:Jan"
endif
if Year1$ = "not found" then Year1$ = "1999"
endif
if Month1$ = "not found" then Month1$ = "Jan"
endif
if FieldArray$(21) = "not found" THEN FieldArray$(21) = "1999"
endif
if FieldArray$(22) = "not found" THEN FieldArray$(22) = "00:00:00"
endif
if FieldArray$(23) = "not found" THEN FieldArray$(23) = "00:00:00"
endif
'print month1$ - comment out when you're sure it's working
END SUB
'***********************************************************

' Convert month to numerals**************
SUB CHECKMONTH
IF Month1$ = "Jan" then  Month = 01
IF Month1$ = "Feb" then  Month = 02
IF Month1$ = "Mar" then  Month = 03
IF Month1$ = "Apr" then  Month = 04
IF Month1$ = "May" then  Month = 05
IF Month1$ = "Jun" then  Month = 06
IF Month1$ = "Jul" then  Month = 07
IF Month1$ = "Aug" then  Month = 08
IF Month1$ = "Sep" then  Month = 09
IF Month1$ = "Oct" then  Month = 10
IF Month1$ = "Nov" then  Month = 11
IF Month1$ = "Dec" then  Month = 12
END SUB
'***********************************************

'UV Index string**************************************
sub UVINDEX
uv1 = val(FieldArray$(14))
uv2$ = ""
Text 620,378, "     ", LM,2, 2, RGB(67,157,229),RGB(25,28,37) 'print blank UV String
if uv1 < 3 then
  uv2$ = " LOW"
elseif uv1 = 3 and uv1 < 6 then
  uv2$ = "Moderate"
elseif uv1 = 6 and uv1 < 8 then
  uv2$ = " HIGH"
elseif uv1 = 8 and uv1 < 11 then
  uv2$ = "Very High"
  elseif1 uv1 = 11 or uv1 > 11 then
  uv2$ = "EXTREME"
endif
endif
endif
endif
endif
Text 620,378, uv2$, LM,2, 2, RGB(67,157,229),RGB(25,28,37) 'print UV String
END SUB
'*************************************************

'Sub to shorten the description so it fits on the the display*************
SUB DESCRIPTION
IF desc0$ = "scattered clouds" then desc0$ = "broken clouds"
endif
IF desc0$ = "light intensity drizzle rain" then desc0$ = "hard drizzle"
endif
IF desc0$  = "thunderstorm with light rain" then desc0$  = "thunderstorm "
endif
IF desc0$ = "thunderstorm with rain" then desc0$ = "thunderstorm"
endif
IF desc0$ = "thunderstorm with heavy rain" then desc0$) = "thunderstorm"
endif
IF desc0$ = "thunderstorm with light drizzle" then desc0$ = "thunderstorm "
endif
IF desc0$ = "thunderstorm with heavy drizzle" then desc0$ = "thunderstorm"
endif
IF desc0$ = "light intensity drizzle" then desc0$ = "light drizzle"
endif
IF desc0$ = "heavy intensity drizzle" then desc0$ = "heavy drizzle"
endif
IF desc0$ = "light intensity drizzle rain" then desc0$ = "hard drizzle"
endif
IF desc0$ = "heavy intensity drizzle rain" then desc0$ = "heavy drizzle"
endif
IF desc0$ = "shower rain and drizzle" then desc0$ = "showers"
endif
IF desc0$ = "heavy intensity rain" then desc0$ = "heavy rain"
endif
IF desc0$ = "light intensity shower rain" then desc0$ = "light showers"
endif
IF desc0$ = "heavy intensity shower rain" then desc0$ = "heavy showers"
endif
IF desc0$ = "ragged shower rain" then desc0$ = "showers"
endif
IF desc0$ = "light rain and snow" then desc0$ = "rain & snow"
endif
IF desc0$ = "light shower snow" then desc0$ = "light snow"
endif
IF desc0$ = "heavy shower snow" then desc0$ = "heavy snow"
endif
if desc2$ = "Clear" then desc2$ = " clear sky"
endif
END SUB
'********************************************************************************

'sub to display either up or down arrow to show the pressure increasing or decreasing

'***FONT is "various_symbols" FROM the Embedded Fonts folder in the MM firmware zip You HAVE to install this font to make this arrow work*****
SUB PRESSICON
if prs2tmp > prs1tmp  then   'IF tomorrow's pressure is higher then todays
  Text 405,130,ZA,LM,8,2,rgb(green),RGB(48,35,29)   'draw up arrow  Left side of screen
  Text 760,130,ZA,LM,8,2,rgb(GREEN),RGB(48,35,29)  'draw up arrow  Left side of screen
elseif prs2tmp < prs1tmp  then  'IF tomorrow's pressure is lower then todays
  Text 405,130,ZB,LM,8,2,rgb(red),RGB(48,35,29) 'draw down arrow
  Text 760,130,ZB,LM,8,2,rgb(red),RGB(48,35,29) 'draw down arrow
ENDIF
endif
END SUB
'***************************************************************************

' Interrupt Sub to display the clock
Sub UpDateTime ' called by 1 second interrupt from SetTick
TEXT 10,50, "         ", LM,6, 1, RGB(136,184,62), RGB(12,26,8)  'display current time
TEXT 10,50, Time$, LM,6, 1, RGB(136,184,62), RGB(12,26,8)  'display current time
Text 290,35, dow1$, LM,4, 2, RGB(136,184,62), RGB(12,26,8)   'display current day
Text 280,75, Day1$ + " " + Month1$, LM,4, 1, RGB(136,184,62), RGB(12,26,8)'display current day of week and month
End Sub
'****************************************************************


'**************Touch Control  FOR FUTURE USE **************************
'Sub PenDown
'   Select CASE Touch(REF)
'       CASE GUI_FORECAST1 'is the FORECAST button pressed?
'            FORECAST1    'call sub FORECAST
'       CASE GUI_button2     'FUTURE USE
'            DAY2         'FUTURE USE
'       CASE GUI_button3     'FUTURE USE
'            DAY3        'FUTURE USE
'       CASE ELSE         ''FUTURE USE
'            EXIT SUB
'    END SELECT
'END SUB
'***************************************************************************
'
''Forecast Sub to display the next 5 days weather on the 2nd screen*************
'SUB FORECAST1  
'cls  'clear the screen
'dow1$ = "Sat"   'Remove when integrated into the weather code properly
'dow2$ = "Sun"   'Remove when integrated into the weather code properly
'dow3$ = "Mon"   'Remove when integrated into the weather code properly
'dow4$ = "Tue"   'Remove when integrated into the weather code properly
'dow5$ = "Wed"   'Remove when integrated into the weather code properly
'RBOX 00,00,798,94,15, RGB(136,184,62), RGB(12,26,8)   ' Box around  time
'RBOX 00,96,798,94,15, RGB(200,148,77), RGB(22,20,15)  ' Box around  temp
'RBOX 00,192,798,94,15, RGB(67,157,229), RGB(25,28,37)  ' Box around  UV Index box
'RBOX 00,288,798,94,15, RGB(200,148,77), RGB(48,35,29) ' Box around  pressure
'RBOX 00,384,798,94,15, RGB(136,184,62), RGB(12,26,8)   'box around description
'
'DAYSUB    ' get the correct days to display on the forecast screen ************************** 
'
'Text 10,55, dow1$, LM,4, 2, RGB(136,184,62), RGB(12,26,8)   'Tomorrow's Day
'Text 10,145, dow2$, LM,4, 2, RGB(200,148,77), RGB(22,20,15)   'Day after tomorrow
'Text 10,240, dow3$, LM,4, 2, RGB(67,157,229), RGB(25,28,37)  '2 Days time
'Text 10,335, dow4$, LM,4, 2, RGB(200,148,77), RGB(48,35,29)   '3 Days time
'Text 10,430, dow5$, LM,4, 2, RGB(136,184,62), RGB(12,26,8)   '4 days time
'
'' WHAT I would like here is a way to set a timer then the screen clears and redraws the "normal screen" ****
'
'endif
'
'
'
''*******THIS DOESN'T WORK FOR SOME REASON**********
'SUB DAYSUB
'IF dow1$ = "Mon" then 
'dow2$ = "Tue" 
'dow3$ = "Wed" 
'dow4$ = "Thu"
'dow5$ = "Fri" 
'ELSE
'IF dow1$ = "Tue" then
'dow2$ = "Wed"
'dow3$ = "Thu"
'dow4$ = "Fri"
'dow5$ = "Sat"
'Else
'IF dow1$ = "Wed" then
'dow2$ = "Thu"
'dow3$ = "Fri"
'dow4$ = "Sat"
'dow5$ = "Sun"
'Else
'IF dow1$ = "Thu" then
'dow2$ = "Fri"
'dow3$ = "Sat"
'dow4$ = "Sun"
'dow5$ = "Mon"
'Else
'IF dow1$ = "Fri" then
'dow2$ = "Sat"
'dow3$ = "Sun"
'dow4$ = "Mon"
'dow5$ = "Tue"
'Else
'IF dow1$ = "Sat" then
'dow2$ = "Sun"
'dow3$ = "Mon"
'dow4$ = "Tue"
'dow5$ = "Wed"
'Else
'IF dow1$ = "Sun" then
'dow2$ = "Mon"
'dow3$ = "Tue"
'dow4$ = "Wed"
'dow5$ = "Thu"
'ENDIF
'ENDIF
'ENDIF
'ENDIF
'ENDIF
'ENDIF
'ENDIF
'END SUB
''**********************************************


'Subroutines to make the compass pointer move to the correct position
sub moveto(angle as integer)
local integer xs=x, ys=y, ws=w, hs=h
rotatetriangle(angle,0,radius,x0,y0,x1,y1,x2,y2)
pxx0=xx0+pivot_x
pyy0=yy0+pivot_y-radius
pxx1=xx1+pivot_x
pyy1=yy1+pivot_y-radius
pxx2=xx2+pivot_x
pyy2=yy2+pivot_y-radius
getlimits(x, y, w, h)
' blit write and blit close first time in will error so skip
ON ERROR SKIP 2
blit read #1, x, y, w, h
BLIT WRITE #1, xs, ys, ws, hs 'restore the save background
blit close #1
blit read #1, x, y, w, h
triangle pxx0, pyy0, pxx1, pyy1, pxx2, pyy2, rgb(215,255,119), rgb(215,255,119) 'COLOUR OF TRIANGLE
end sub

sub getlimits(x as integer, y as integer, w as integer, h as integer)
Local integer i,max_x=0,min_x=MM.HRES,max_y=0,min_y=MM.VRES
if(pxx0(i)>max_x)then max_x=pxx0(i)
if(pxx1(i)>max_x)then max_x=pxx1(i)
if(pxx2(i)>max_x)then max_x=pxx2(i)
if(pxx0(i)<min_x)then min_x=pxx0(i)
if(pxx1(i)<min_x)then min_x=pxx1(i)
if(pxx2(i)<min_x)then min_x=pxx2(i)
if(pyy0(i)>max_y)then max_y=pyy0(i)
if(pyy1(i)>max_y)then max_y=pyy1(i)
if(pyy2(i)>max_y)then max_y=pyy2(i)
if(pyy0(i)<min_y)then min_y=pyy0(i)
if(pyy1(i)<min_y)then min_y=pyy1(i)
if(pyy2(i)<min_y)then min_y=pyy2(i)
x=min_x
y=min_y
w=max_x-min_x+2
h=max_y-min_y+2
end sub
'
' Simple trig to rotate the vertices of a triangle
' specified as x0,y0,x1,y1,x2,x2 relative to coordinate 0,0
' by the angle specified
' and then translate them about the supplied real centre x,y
' the calculated coordinates are then placed into element n of a set of coordinate arrays
'
sub rotatetriangle(angle as float, x as integer, y as integer, x0 as integer, y0 as integer, x1 as integer, y1 as integer, x2 as integer, y2 as integer)
local float sine=sin(rad(angle)),cosine=cos(rad(angle))
local integer x0a,y0a,x1a,y1a,x2a,y2a
x0a= x0*cosine - y0 * sine + x
y0a= y0*cosine + x0 * sine + y
x1a= x1*cosine - y1 * sine + x
y1a= y1*cosine + x1 * sine + y
x2a= x2*cosine - y2 * sine + x
y2a= y2*cosine + x2 * sine + y
xx0=x0a
yy0=y0a
xx1=x1a
yy1=y1a
xx2=x2a
yy2=y2a
end sub
'*******End of compss routine  *******************************


'***********Functions****************

'Get the number of field arrays from the serial input
Function GetFieldArray( Record$, Delimiter$, KeepQuotes ) AS INTEGER
Local Index, Char, InQuote, Count
InQuote = 0
Count = 0
FieldArray$(Count) = ""
If Delimiter$ = "" Then Delimiter$ = ","
For Index = 1 To Len(Record$)
  Char = Asc(Mid$(Record$, Index, 1))
  If Char = 34 Then InQuote = Not InQuote
  If Not InQuote And Instr(Delimiter$, Chr$(char)) >= 1  Then
    Count = Count + 1
    FieldArray$(Count) = ""
  Else
    if Char <> 34 Or KeepQuotes Then
      FieldArray$(Count) = FieldArray$(Count) + Chr$(char)
    EndIf
  EndIf
Next
GetFieldArray = Count + 1
End Function

' calculate the minutes since midnight 1st Jan 2014
Function GetMins(yr, mth, day, hr, min)
GetMins = (yr - 14) * (365 * 24 * 60) + ((yr - 13) \ 4) * (24 * 60)
GetMins = GetMins + (md(mth) * (24 * 60))
GetMins = GetMins + ((day - 1) * (24 * 60))
GetMins = GetMins + (hr * 60)
GetMins = GetMins + min
If (yr - 16) Mod 4 = 0 And mth > 2 Then GetMins = GetMins + (24 * 60)
End Function


' convert minutes back into the time (as a string)
Function GetTime$(minutes)
Local hr, min, am$
am$ = "AM"
hr = (minutes \ 60) Mod 24
'If hr > 12 Then am$ = "PM" : hr = hr - 12
'If hr = 0 Then hr = 12
min = minutes Mod 60
GetTime$ = Str$(hr) + ":"
GetTime$ = GetTime$ + Right$("0" + Str$(min), 2) + ":"
GetTime$ = GetTime$ + Right$("0" + Str$(sec), 2) + " " '  + am$
GetTime$=" " + GetTime$
End Function


' get the minutes that GMT will start or end in a month
' modified for NORTH OF THE EQUATOR - FOR SOUTH USE THE FUNCTION BELOW THIS
Function GetDST(yr As INTEGER, mth As INTEGER, hr As INTEGER) As INTEGER
Local As INTEGER d, m, n
m = GetMins(yr, mth, 1, hr, 0)
d = ((m \ (24 * 60)) + 3) Mod 7
m =  m + (((7 - d) Mod 7) * 24 * 60)
n = GetMins(yr, mth + 1, 1, 0, 0)
Do While m + (7 * 24 * 60) < n
  m = m + (7 * 24 * 60)
Loop
GetDST = m
End Function
'
'' get the minutes that DST will start or end in a month
'Function GetDST(yr, mth, hr)
'  Local d, m
'  m = GetMins(yr, mth, 1, hr, 0)
'  d = ((m \ (24 * 60)) + 3) Mod 7
'  GetDST =  m + (((7 - d) Mod 7) * 24 * 60)
'End Function
'

Function HumanTime(UT As Integer,opt As Integer) As String
' take seconds since 1970-01-01 (unixtime) and converts to a human form date/time as
' if opt=0 (or not specified) the format is dd-mm-yyyy hh:mm:ss" to match the format of DATE$
' if opt<>0 the date part is returned as yyyy-mm-dd to aid sorting and avoid
Local integer d,m,s,y,z
If UT<0 Then HumanTime$="":Exit Function
y=1970:d=UT\86400:s=UT Mod 86400
Do
  z=365+IsLeapYear(y)
  If d>=z Then
    d=d-z:y=y+1
  Else
    Exit Do
  EndIf
Loop
'here, Y is the current year and d the remaining days
m=1' start at january
' days between the start of the year and the current month
Do
  z=0
  Select Case m
    Case 1,3,5,7,8,10
      If d>=31 Then d=d-31:z=1
    Case 2
      If IsLeapYear(y)Then
      If d>=29 Then d=d-29:z=1
    Else
      If d>=28 Then d=d-28:z=1
    EndIf
  Case 4,6,9,11
    If d>=30 Then d=d-30:z=1
End Select
If z=1 Then
  m=m+1
Else
  d=d+1:Exit Do 'first day is 1 not 0
EndIf
Loop
If opt<>0 Then
  HumanTime$=Str$(y)+"-"+ZPad$(m,2)+"-"+ZPad$(d,2)
Else
  HumanTime$=ZPad$(d,2)+"-"+ZPad$(m,2)+"-"+Str$(y)
EndIf
y=s\3600:s=s-y*3600
m=s\60:s=s-m*60
HumanTime$=HumanTime$+" "+ZPad$(y,2)+":"+ZPad$(m,2)+":"+ZPad$(s,2)
End Function

Function IsLeapYear(n as integer) as integer
IsLeapYear=((n Mod 4=0) And (n Mod 100 <>0)) Or (n Mod 400=0)
End Function

Function ZPad$(x As integer,y As integer)
'adds y leading zeroes to X
ZPad$=Right$(String$(y,"0")+Str$(x),y)
End Function
